<?php
require "../policy/get/getPolicy.php";

function getServer()
{
   global $UserAccessLevel;
   $sock = Login();
   /* getters data */
   $getterServer = ParamGet($sock, "server");
   $getterRecorder = ParamGet($sock, "recorder");
   $getterVideo = ParamGet($sock, "video");
   $getterTime = ParamGet($sock, "time");
   $getterSecurity = ParamGet($sock, "security");
   $getterCamStatInfo = ParamGet($sock, "CamStatInfo");
   $getterServerDiscovery = ParamGet($sock, "serverDiscovery");
   $getterDiskInfo = ParamGet($sock, "DiskInfo");
   /*  */
   $serverTitle = urlencode(getName($getterServer->server));
   header("Title: " . $serverTitle);
   $json = [];
   $access = 1;
   if (intval($UserAccessLevel) == 101) {
      $access = 11;
   } elseif (intval($UserAccessLevel) != 1) {
      $access = intval($UserAccessLevel) / 10;
   }
   $json["userAccess"] = $access;
   $server = $getterServer->server;
   $json["ip"] = gethostbyname($_SERVER["SERVER_ADDR"]);
   $json["server_version"] = isset($server->video->version) ? $server->video->version : "";
   $json["hddHotSwap"] = isset($server->HddHotSwap) ? $server->HddHotSwap : false;
   $json["upLink"] = getUpLink(isset($server->uplink) ? $server->uplink : (object) []);
   $json["modelFeature"] = isset($server->ModelFeature) ? $server->ModelFeature : 0;
   $json["timeoffset"] = isset($server->timeoffset) ? $server->timeoffset : 0;
   $json["cpu"] = isset($server->speed) ? $server->speed : 0;
   $json["boot"] = isset($server->service->boot) ? $server->service->boot : 0;
   $json["access"] = isset($server->access)
      ? [cutAccess($server->access)]
      : [["read" => 1, "write" => 1, "play" => 1, "ptz" => 1]];
   $json["users"] = getAllUsersServers($getterSecurity);
   $json["serial"] = isset($server->sticker) ? $server->sticker : "000000000000000";
   $json["domain"] = gethostbyname($_SERVER["SERVER_NAME"]);
   $json["server_name"] =
      isset($server->title1251) && $server->title1251 != "" ? $server->title1251 : "Видеосервер";

   $json["archiveEncryption"] = isset($server->archiveEncryption) ? $server->archiveEncryption : 0;
   $json["mdr"] = isset($server->mdr) ? $server->mdr : 0;
   $json["noNet"] = isset($server->NoNet) ? true : false;
   /* for 2.1.6.2 */
   $json["httpdigestport"] = isset($server->httpdigestport) ? $server->httpdigestport : 7004;
   $json["rtspport"] = isset($server->rtspport) ? $server->rtspport : 7005;
   $json["apifeatures"] = isset($server->apifeatures) ? $server->apifeatures : 0;
   /*  */
   if (isset($server->ntp)) {
      $ntp = $server->ntp;
      $ntp->enabled = isset($ntp->ntpserverip) ? 1 : 0;
      if (!isset($ntp->ntptzoffset)) {
         $ntp->ntptzoffset = 0;
      } elseif (isset($ntp->ntptzoffset) && $ntp->ntptzoffset != 0) {
         $ntp->ntptzoffset = $ntp->ntptzoffset / 3600;
      } else {
         $ntp->ntptzoffset = 0;
      }
      $json["ntp"] = $ntp;
   }

   if (isset($server->snmp)) {
      $snmp = $server->snmp;
      $snmp->enabled = isset($server->snmp->enabled) ? (bool) $server->snmp->enabled : false;
      /*  if (!isset($server->snmp->enabled) || $server->snmp->enabled === "false" || $server->snmp->enabled == "0" || $server->snmp->enabled == 0) {
            $snmp->enabled = false;
        } else if (
            isset($server->snmp->enabled)
            && ($server->snmp->enabled === "true" || $server->snmp->enabled === "1" || $server->snmp->enabled === 1)
        ) {
            $snmp->enabled = true;
        } */
      if (isset($snmp->trapport) && $snmp->trapport == 0) {
         $snmp->trapport = 162;
      }
      if (!isset($snmp->trapport)) {
         $snmp->trapport = 162;
      }
      $json["snmp"] = $snmp;
   }

   if (isset($server->nat)) {
      $nat = $server->nat;

      $nat->enable = isset($server->nat->enable) ? (bool) $server->nat->enable : false;
      $nat->address = isset($server->nat->address) ? $server->nat->address : "";
      $nat->rtsp_port = isset($server->nat->rtsp_port) ? $server->nat->rtsp_port : 0;
      $nat->http_port = isset($server->nat->http_port) ? $server->nat->http_port : 0;

      $json["nat"] = $nat;
   }

   if (isset($server->mdr)) {
      $json["mdr"] = (bool) $server->mdr;
   }

   /* get recodred settings */

   if (isset($getterRecorder) && isset($getterRecorder->recorder->storage->mptnum)) {
      $json["mptnum"] = $getterRecorder->recorder->storage->mptnum;
   } else {
      $json["mptnum"] = 0;
   }
   if (isset($getterRecorder) && isset($getterRecorder->recorder->storage->speed)) {
      $json["diskWrite"] = $getterRecorder->recorder->storage->speed;
   } else {
      $json["diskWrite"] = 0;
   }

   /* get video settings */

   $arr2 = $getterVideo->video;

   $ipcams = isset($arr2->ipcams) ? $arr2->ipcams : 0;
   $json["ipcams"] = $ipcams;

   $inputs = isset($arr2->inputs) ? $arr2->inputs : 0;
   $json["inputs"] = $inputs;

   if ($json["ipcams"] > $json["inputs"]) {
      $json["ipcams"] = $json["inputs"];
   }
   $json["time"] = getTime($getterTime);
   $json["cameras"] = getCamerasNames($getterVideo, $getterCamStatInfo, $getterSecurity);

   $health = [];
   array_push($health, getCameraHealth($getterVideo, $getterCamStatInfo)); //+
   array_push($health, isCanDoItServe($getterServer, "read") ? getDisksHealthServer($getterDiskInfo) : false);

   $json["health"] = $health;
   $servers = getAllServers($getterServerDiscovery);
   $servers = sort_nested_arrays($servers, ["webport" => "asc"]);
   $json["servers"] = $servers;
   $json["adapters"] = adapters($server);
   $recorder = ParamGet($sock, "recorder");
   $recorder = isset($recorder->recorder->storage->mptnum) ? $recorder->recorder->storage->mptnum : 0;
   $json["mptnum"] = $recorder;
   $json["storage"] = getDiskInfo($getterDiskInfo);
   $json["hasDisk"] = !empty(ParamGet($sock, "DiskInfo"));
   socket_close($sock);
   return $json;
}
function getServers()
{
   $sock = Login();
   $getterServerDiscovery = ParamGet($sock, "serverDiscovery");
   $servers = getAllServers($getterServerDiscovery);
   $servers = sort_nested_arrays($servers, ["webport" => "asc"]);
   socket_close($sock);
   return $servers;
}
function getDiscovery()
{
   $sock = Login();
   $discovery = ServersDiscovery($sock);
   socket_close($sock);
   return $discovery;
}

function isWriteConnect($user)
{
   if (!isset($user->deny->misc->write)) {
      return true;
   }
   if ($user->deny->misc->write == 8) {
      return true;
   }
   if ($user->deny->misc->write == 16) {
      return false;
   }
   if ($user->deny->misc->write == 24) {
      return false;
   }
   return true;
}

function getAccessConnect($server, $userLvl, $gettersSecurity, $sock)
{
   global $UserId;
   $access = isset($server->access)
      ? [cutAccess($server->access)]
      : [["read" => 1, "write" => 1, "play" => 1, "ptz" => 1]];
   $access = isset($access[0]->write) ? (int) $access[0]->write : 1;

   $isNotAccessWrite = $access > $userLvl;
   if ($isNotAccessWrite) {
      return false;
   }

   $user = GetUserById($UserId, $gettersSecurity);
   $isWrite = isWriteConnect($user);
   if ($isWrite === false) {
      return false;
   }

   $getterDiskInfo = ParamGet($sock, "DiskInfo"); //write

   $getDisk = getDiskInfo($getterDiskInfo);

   $getDisk = count($getDisk) > 0 ? true : false; // в самом клиенте будет использоваться для поиска из архива

   return $getDisk;
}
function getServerBasic()
{
   try {
      global $UserAccessLevel;
      global $UserId;
      $sock = Login();
      /* $user = GetUserById($UserId, $sock); */
      $gettersSecurity = ParamGet($sock, "security");
      $getterServer = ParamGet($sock, "server");

      $json = [];
      $server = $getterServer->server;
      $json["name"] = getName($server);
      $json["port"] = getPort($server);
      $json["userAccess"] = getNormalUserAccess($UserAccessLevel);
      $json["userID"] = intval(getUserIndex($gettersSecurity));
      $json["server_version"] = isset($server->video->version) ? $server->video->version : "";
      $json["userIndex"] = getUserIndex($gettersSecurity);
      $json["serverVersion"] = $server->video->version;
      $json["ip"] = gethostbyname($_SERVER["SERVER_ADDR"]);
      $json["domain"] = gethostbyname($_SERVER["SERVER_NAME"]);
      $json["accessLevel"] = isset($server->access)
         ? (object) cutAccess($server->access)
         : (object) ["read" => 1, "write" => 1, "play" => 1, "ptz" => 1];
      $json["access"] = getUserAccessByServer($UserId, $gettersSecurity);
      $json["hasStorage"] = getAccessConnect($server, $json["userAccess"], $gettersSecurity, $sock);
      $json["timezones"] = getTimezonesForBase($server);
      $json["nvid"] = $server->checkver;
      socket_close($sock);
      return $json;
   } catch (\Throwable $th) {
      echo $th;
   }
}
function getPort($server)
{
   $port = 7000; // по умолчанию
   $adapters = getAdaptersPort($server);

   foreach ($adapters as $adapter) {
      if ($adapter["server_ip"] == $_SERVER["SERVER_NAME"]) {
         $port = $adapter["port"];
      }
   }
   return $port;
}
function getAdaptersPort($server)
{
   $adapters = [];
   if (isset($server->eth0) && $server->eth0 == 1) {
      $adapters[0]["name"] = "";
      $adapters[0]["enabled"] = $server->eth0;
      isset($server->ip) ? ($adapters[0]["server_ip"] = $server->ip) : ($adapters[0]["server_ip"] = "");
      isset($server->mask)
         ? ($adapters[0]["server_mask"] = $server->mask)
         : ($adapters[0]["server_mask"] = "");
      isset($server->port) ? ($adapters[0]["port"] = $server->port) : ($adapters[0]["port"] = 0);
      isset($server->mac0) ? ($adapters[0]["mac"] = $server->mac0) : ($adapters[0]["mac"] = "no data");
      isset($server->eth0spid) ? ($adapters[0]["speed"] = $server->eth0spid) : ($adapters[0]["speed"] = 0);
      isset($server->eth0outspeed)
         ? ($adapters[0]["out_speed"] = $server->eth0outspeed)
         : ($adapters[0]["out_speed"] = 0);
      if (
         isset($server->eth1inspeed) &&
         (($server->eth1 == 0 || !isset($server->ip2)) && ($server->eth2 == 0 || !isset($server->ip3)))
      ) {
         $adapters[0]["in_speed"] = $server->eth1inspeed;
      }
      if (isset($server->gateway)) {
         $adapters[0]["gateway"] = $server->gateway;
      }
   }
   if (isset($server->eth1) && $server->eth1 == 1) {
      $adapters[1]["name"] = "(Камеры)";
      $adapters[1]["enabled"] = $server->eth1;
      isset($server->ip2) ? ($adapters[1]["server_ip"] = $server->ip2) : ($adapters[1]["server_ip"] = "");
      isset($server->mask2)
         ? ($adapters[1]["server_mask"] = $server->mask2)
         : ($adapters[1]["server_mask"] = "");
      $adapters[1]["port"] = false;
      isset($server->mac1) ? ($adapters[1]["mac"] = $server->mac1) : ($adapters[1]["mac"] = "no data");
      isset($server->eth1spid) ? ($adapters[1]["speed"] = $server->eth1spid) : ($adapters[1]["speed"] = 0);
      isset($server->eth1inspeed) && isset($server->ip2)
         ? ($adapters[1]["in_speed"] = $server->eth1inspeed)
         : ($adapters[1]["in_speed"] = 0);
   }
   if (isset($server->eth2) && $server->eth2 == 1) {
      $adapters[2]["name"] = "(Камеры)";
      $adapters[2]["enabled"] = $server->eth2;
      isset($server->ip3) ? ($adapters[2]["server_ip"] = $server->ip3) : ($adapters[2]["server_ip"] = "");
      isset($server->mask3)
         ? ($adapters[2]["server_mask"] = $server->mask3)
         : ($adapters[2]["server_mask"] = "");
      $adapters[2]["port"] = false;
      isset($server->mac2) ? ($adapters[2]["mac"] = $server->mac2) : ($adapters[2]["mac"] = "no data");
      isset($server->eth2spid) ? ($adapters[2]["speed"] = $server->eth2spid) : ($adapters[2]["speed"] = 0);
      isset($server->eth2inspeed)
         ? ($adapters[2]["in_speed"] = $server->eth2inspeed)
         : ($adapters[2]["in_speed"] = 0);
   }
   if (isset($server->eth3) && $server->eth3 == 1) {
      $adapters[3]["name"] = "(Клиенты)";
      $adapters[3]["enabled"] = $server->eth3;
      isset($server->ip1) ? ($adapters[3]["server_ip"] = $server->ip1) : ($adapters[3]["server_ip"] = "");
      isset($server->mask1)
         ? ($adapters[3]["server_mask"] = $server->mask1)
         : ($adapters[3]["server_mask"] = "");
      isset($server->port) ? ($adapters[3]["port"] = $server->port) : ($adapters[3]["port"] = 0);
      isset($server->mac3) ? ($adapters[3]["mac"] = $server->mac3) : ($adapters[3]["mac"] = "no data");
      isset($server->eth3spid) ? ($adapters[3]["speed"] = $server->eth3spid) : ($adapters[3]["speed"] = 0);
      isset($server->eth3outspeed)
         ? ($adapters[3]["out_speed"] = $server->eth3outspeed)
         : ($adapters[3]["out_speed"] = 0);
   }
   return $adapters;
}
function exportServer()
{
   $sock = Login();
   $server = ParamGet($sock, "server");
   return $server->server;
}
